/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include <stdio.h>  
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <signal.h> 
#include "DCSApi.h"
#include "PMApi.h"

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}

int main(int argc, char *argv[])
{
	int ret = 0;
	int i=0;
	char c0;

	/*initialize the DCS*/
	ret = DCS_Initialize();
	DCS_ReturnValue_handler( ret);

	ULONG batCount;
	ret=DCS_GetBatteryCount(&batCount);
	printf("*** press any key to continue\n");
	scanf("%c",&c0);

	printf("DCS_GetBatteryCount\n");
	DCS_ReturnValue_handler( ret);

	DCS_Battery_Info battery;
	battery.BatteryStatus=0;

	ret=DCS_GetBatteryInfo( &battery, 0);
	printf("*** press any key to continue\n");
	scanf("%c",&c0);

	printf("battary's Status :%d\n", battery.BatteryStatus);

	printf("battary's RemainPercent :%d\n", battery.RemainPercent);

	printf("battary's RemainTime :%d\n", battery.RemainTime);

	printf("battary's DesignedCapacity :%d\n", battery.DesignedCapacity);

	printf("battary's FullChargedCapacity :%d\n", battery.FullChargedCapacity);

	printf("battary's Chemistry :%s\n", battery.Chemistry);

	printf("battary's Current :%d\n", battery.Current);

	printf("battary's Voltage :%d\n", battery.Voltage);

	printf("battary's Temperature :%d\n", battery.Temperature);

	/*uninitialize the DCS*/

	ret=DCS_Uninitialize();
	DCS_ReturnValue_handler( ret);

	return 0;
}

